**********************************************************************
*This program combines key variables from SIH household-level data from 2003/04 to 2017/18 as well as 2003/04 HES household-level data 
*household-level data in 2007/08 is omitted because wealth variables in the year are missing 
**********************************************************************
cd "<place directory here>"
global path "<place directory here>"
global data "$path\data" //this is where you save the clean data
global rawdata "$path\rawdata" //this is where you save the raw SIH data 

*************** 2003/04 *************** 

 
*NO OFFSET ACCOUNTS

use "$path\rawdata\SIH03BH.dta" , clear
g debts= LIASDCH+LIAOPCH+LIARPCH +LIAINVCH+LIAOTCH+LIAHECCH+LIASFSCH+LIACCCH
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename STATEHBC state

rename FEMHHBC femshh
rename MALEHHBC maleshh

rename NOEARNBC noearnbc

gen investment_inc= INVESTCH
gen bus_inc= IOBTCH
gen all_inc= INCTOTCH
gen gov_inc =ITGCBCH
gen super_inc =ISUPERCH
gen employee_inc =IWSUCH

g assets= VFINCH +VSHARCH+VTRTCH + VDEBCH+VIBUSCH+ VPLNCH+VINVOTCH+HVALUECH+VRPRCH+VNRPRCH+VUBUSCH+VCONTCH+VVEHICH+VOTASSCH+VSUPGCH+VSUPNCH

g year = 2004

rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 
rename ISUPERCH superinc 
rename LFSRH lfstatus 


g dinc = DISPCH 
g dinc_prev = DISPPH


g children = NUMU15BC
g persons = PERSHBC
g adults = persons - children
g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)

g tenure = TENURECF 
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10
replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16
replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26
replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


*Wealth variables - to define HtM
g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VTRTCH


g dep = VFINCH
g off = 0
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH

g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g car = VVEHICH 

g inc_source=PSRCCH


keep ABSHID year liaopch liarpch state femshh maleshh  noearnbc investment_inc bus_inc all_inc gov_inc super_inc employee_inc debts assets hwt ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone inc_source
save "$path\data\liq2003.dta"


******************* 2005/06 ******************* 


*NO OFFSET ACCOUNTS

use "$path\rawdata\Sih05bh.dta" , clear
g debts= LIASDCH+LIAOPCH+LIARPCH +LIAINVCH+LIAOTCH+LIAHECCH+LIASFSCH+LIACCCH

rename LIAOPCH liaopch
rename LIARPCH liarpch
rename STATEHBC state
g year = 2006

rename FEMHHBC femshh
rename MALEHHBC maleshh

rename NOEARNBC noearnbc
gen investment_inc= INVESTCH
gen bus_inc= IOBTCH
gen all_inc= INCTSCH
gen gov_inc =ITGCBCH
gen super_inc =ISUPERCH
gen employee_inc =IWSUCH
g assets= VFINCH +VSHARCH+VTRTCH + VDEBCH+VIBUSCH+ VPLNCH+VINVOTCH+HVALUECH+VRPRCH+VNRPRCH+VUBUSCH+VCONTCH+VVEHICH+VOTASSCH+VSUPGCH+VSUPNCH



rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 


g dinc = DISPCH
g dinc_prev = DISPPH

g adults = NOMEMHBC
g children = NUMU15BC + NONDEPBC

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)


g tenure = TENURECF
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VTRTCH


g dep = VFINCH
g off = 0
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH

g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g car = VVEHICH 

g inc_source=PSRCCH


keep ABSHID year liaopch liarpch state  femshh maleshh  noearnbc investment_inc bus_inc all_inc gov_inc super_inc employee_inc debts assets  hwt  ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone inc_source
save "$path\data\liq2005.dta" 




******************* 2009/10 ******************* 


*NO OFFSET ACCOUNTS

use "$path\rawdata\sih10bh.dta" , clear
g debts= LIASDCH+LIAOPCH+LIARPCH +LIAINVCH+LIAOTCH+LIAHECCH+LIASFSCH+LIACCCH
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename STATEHBC state 
g year = 2010


rename FEMHHBC femshh
rename MALEHHBC maleshh

rename NOEARNBC noearnbc

gen investment_inc= INVESTCH
gen bus_inc= IOBTCH
gen all_inc= INCTSCH8
gen gov_inc =ITGCBCH8
gen super_inc =ISUPERCH
gen employee_inc =IWSUCH
g assets= VFINCH +VSHARCH+VPUTCH+  VPRTCH+ VSIPCH+VDEBCH+VIBUSCH+ VPLNCH+VINVOTCH+HVALUECH+VRPRCH+VNRPRCH+VUBUSCH+VCONTCH+VVEHICH+VOTASSCH+VSUPGCH+VSUPNCH


rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 

g dinc = DISPSCH8
g dinc_prev = DISPPH8

g tenure = TENURECF

g adults = NOMEMHBC
g children = NUMU15BC + NONDEPBC

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)


g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30

*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VPUTCH+VPRTCH+VSIPCH


g dep = VFINCH
g off = 0
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH

g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 


g car = VVEHICH 
rename NETIR netir

g inc_source=PSRCSCH

keep ABSHID year liaopch liarpch state  femshh maleshh  noearnbc  investment_inc bus_inc all_inc gov_inc super_inc employee_inc debts assets hwt ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone netir inc_source
save "$path\data\liq2009.dta" 



******************* 2011/12 ******************* 
use "$path\rawdata\sih11bh.dta" , clear

g debts= LIASDCH+LIAOPCH+LIARPCH +LIAINVCH+LIAOTCH+LIAHECCH+LIASFSCH+LIACCCH
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename STATEHBC state 
g year = 2012


rename FEMHHBC femshh
rename MALEHHBC maleshh

rename NOEARNBC noearnbc

gen investment_inc= INVESTCH
gen bus_inc= IOBTCH
gen all_inc= INCTSCH8
gen gov_inc =ITGCBCH8
gen super_inc =ISUPERCH
gen employee_inc =IWSUCH
g assets= VFINCH +VOFTCH +VSHARCH+VPUTCH+  VPRTCH+ VSIPCH+VDEBCH+VIBUSCH+ VPLNCH+VINVOTCH+HVALUECH+VRPRCH+VNRPRCH+VUBUSCH+VCONTCH+VVEHICH+VOTASSCH+VSUPGCH+VSUPNCH

g dep = VFINCH
g off = VOFTCH

rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 
rename NETIR netir

g tenure = TENURECF

g dinc = DISPSCH8
g dinc_prev = DISPPH8


g adults = NOMEMHBC
g children = NUMU15BC + NONDEPBC

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)
*g group = (DCOMP == 33)



g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VPUTCH+VPRTCH+VSIPCH


g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH


g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 


g car = VVEHICH 


g inc_source=PSRCSCH

keep ABSHID year liaopch liarpch state  femshh maleshh  noearnbc investment_inc bus_inc all_inc gov_inc super_inc employee_inc debts assets dep off hwt ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone netir inc_source
save "$path\data\liq2011.dta"




******************* 2013/14 ******************* 

use  "$path\rawdata\sih13bh.dta" , clear

g year = 2014
g debts= LIASDCH+LIAOPCH+LIARPCH +LIAINVCH+LIAOTCH+LIAHECCH+LIASFSCH+LIACCCH

rename LIAOPCH liaopch
rename LIARPCH liarpch
rename STATEHBC state

rename FEMHHBC femshh
rename MALEHHBC maleshh

rename NOEARNBC noearnbc

gen investment_inc= INVESTCH
gen bus_inc= IOBTCH
gen all_inc= INCTSCH8
gen gov_inc =ITGCBCH8
gen super_inc =ISUPERCH
gen employee_inc =IWSUCH

g assets= VFINCH +VOFTCH +VSHARCH+VPUTCH+  VPRTCH+ VSIPCH+VDEBCH+VIBUSCH+ VPLNCH+VINVOTCH+HVALUECH+VRPRCH+VNRPRCH+VUBUSCH+VCONTCH+VVEHICH+VOTASSCH+VSUPGCH+VSUPNCH

g dep = VFINCH
g off = VOFTCH


rename SIHHHWT hwt
rename AGERHBC agehh 
rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 


g dinc = DISPSCH8
g dinc_prev = DISPPH8

g tenure = TENURECF

g adults = NOMEMHBC
g children = NUMU15BC + NONDEPBC

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)


g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


*Wealth variables - to define HtM

g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VPUTCH+VPRTCH+VSIPCH



g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH


g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g car = VVEHICH 

rename NETIR netir

g inc_source=PSRCSCH

keep ABSHID year liaopch liarpch state femshh maleshh  noearnbc investment_inc bus_inc all_inc gov_inc super_inc employee_inc debts assets dep off hwt  ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone netir inc_source
save "$path\data\liq2013.dta"

******************* 2015/16 ******************* 

use  "$path\rawdatasih15bh.dta" , clear

g year=2016

rename abshid ABSHID
rename statehec state 
rename femhhbc femshh
rename malehhbc maleshh

gen investment_inc= investch
gen bus_inc=  iobtch
gen all_inc=  inctsch8
gen gov_inc = itgcbch8 
gen super_inc = isuperch
gen employee_inc = iwsuch

g debts = liasdch + liaopch + liarpch + liavech + liainvch + liaotch + liahecch + liasfsch + liaccch 
g assets = vfinch + voftch + vsharch + vtottch + vsipch + vdebch + vibusch + vplnch + vinvotch + hvaluech  + vrprch + vnrprch + vubusch + vcontch + vvehich + votassch + vsupgch +vsupnch


g dep = vfinch 
g off = voftch 


rename sihhhwt hwt
rename agerhec age
rename wealthh nwealth 
rename isuperch superinc 
rename lfsrh lfstatus 


g dinc = dispsch8 
g dinc_prev = dispph8 

g adults = nomemhbc 
g persons = pershbc
g children = persons-adults


rename dcomp DCOMP 
g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)



g tenure = tenurecf 
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (fsthhcf == 1)

*Wealth variables - to define HtM

g hvalue = hvaluech 
g otherprop = vrprch  
g resassets = hvalue+otherprop

g gsuper = vsupgch 
g psuper = vsupnch  
g super = gsuper+psuper

g trusts = vputch+vprtch+vsipch  


g bank = dep+off

g bonds = vdebch  
g shares = vsharch  

g liqassets = bank + shares + bonds 


g hdebt_purch = towe1ch 
g hdebt_alts = towe2ch  
g hdebt_other = towe3ach
g hdebt_unsec = towe4ch 

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = liaccch 
g pdebt = liavech+liainvch+liaotch 


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 


g liqnw = liqassets - liq_debt

g car = vvehich  

g inc_source=psrcsch

keep ABSHID year liaopch liarpch state femshh maleshh  noearnbc investment_inc bus_inc all_inc gov_inc super_inc employee_inc debts assets dep off hwt  ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone netir inc_source

save "$path\data\liq2015.dta"


******************* 2017/18 ******************* 

use "$path\rawdata\SIH17BH.dta" , clear 
g year=2018

rename abshid ABSHID
rename statehec state 
rename femhhbc femshh
rename malehhbc maleshh

gen investment_inc= investch
gen bus_inc=  iobtch
gen all_inc=  inctsch
gen gov_inc = itgcbch8 
gen super_inc = isuperch
gen employee_inc = iwsuch

g debts = liasdch + liaopch + liarpch + liavech + liainvch + liaotch + liahecch + liasfsch + liaccch 


/*
use "$path\rawdata\SIH17BP.dta" , clear 

keep abshid supbalp supbalnp vsuptot
rename abshid ABSHID 
rename vsuptot super 
*Balance of super paying regular income
rename supbalp super_reginc
*Balance of super paying no regular income
rename supbalnp super_noreginc

collapse(sum) super*, by(ABSHID)
save "$path\data\supertemp.dta"

*/
merge 1:1 ABSHID using "$path\data\supertemp.dta", nogen keep(match master)


g assets = vfinch + voftch + vsharch + vtottch + vsipch + vdebch + vibusch + vplnch + vinvotch + hvaluech  + vrprch + vnrprch + vubusch + vcontch + vvehich + votassch + super 

g dep = vfinch  
g off = voftch



rename sihhhwt hwt
rename agerhec age
rename wealthh nwealth 

rename isuperch superinc 
rename lfsrh lfstatus 

g dinc = dispsch8 


g tenure = tenurecf 
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (fsthhcf == 1)

g adults = nomemhbc 
g persons = pershbc
g children = persons-adults

rename dcomp DCOMP 
g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)


*Wealth variables - to define HtM

g hvalue = hvaluech
g otherprop = vrprch
g resassets = hvalue+otherprop

g trusts = vputch+vprtch+vsipch 

*Includes offset accounts 

g bank = dep+off

g bonds = vdebch 
g shares = vsharch 

g liqassets = bank + shares + bonds 


g hdebt_purch = towe1ch 
g hdebt_alts = towe2ch 
g hdebt_other = towe3ach
g hdebt_unsec = towe4ch 

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = liaccch 
g pdebt = liavech+liainvch+liaotch 


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g liqnw = liqassets - liq_debt

g car = vvehich 

g inc_source=psrcsch

keep ABSHID year liaopch liarpch state femshh maleshh  noearnbc investment_inc bus_inc all_inc gov_inc super_inc employee_inc debts assets dep off hwt ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone netir inc_source
save "$path\data\liq2017.dta"


************** APPENDING DATASETS ************** 

clear

append using "$path\data\liq2003.dta"
append using "$path\data\liq2005.dta"
append using "$path\data\liq2009.dta"
append using "$path\data\liq2011.dta"
append using "$path\data\liq2013.dta"
append using "$path\data\liq2015.dta"
append using "$path\data\liq2017.dta"

rename ABSHID abshid

g hh_investor=0
replace hh_investor=1 if liaopch>0
replace hh_investor=1 if liarpch>0

g hh_size=maleshh+femshh

save "$path\data\2004_2018.dta"

***adding 2003/04 HES data 

use "$path\data\hes03bh.dta" , clear
gen year=2004
rename ABSHID abshid
rename DINC dinc

g debts= LIASDCH+LIAOPCH+LIARPCH +LIAINVCH+LIAOTCH+LIAHECCH+LIASFSCH+LIACCCH
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename STATEHBC state

rename FEMHHBC femshh
rename MALEHHBC maleshh

rename NOEARNBC noearnbc

gen investment_inc= INVESTCH
gen bus_inc= IOBTCH
gen all_inc= INCTOTCH
gen gov_inc =ITGCBCH
gen super_inc =ISUPERCH
gen employee_inc =IWSUCH

g assets= VFINCH +VSHARCH+VTRTCH + VDEBCH+VIBUSCH+ VPLNCH+VINVOTCH+HVALUECH+VRPRCH+VNRPRCH+VUBUSCH+VCONTCH+VVEHICH+VOTASSCH+VSUPGCH+VSUPNCH


rename AGERHBC agehh 


g age = 15 if agehh == 1
replace age = 16 if agehh == 2
replace age = 17 if agehh == 3
replace age = 18 if agehh == 4
replace age = 19 if agehh == 5
replace age = 20 if agehh == 6
replace age = 21 if agehh == 7
replace age = 22 if agehh == 8
replace age = 23 if agehh == 9
replace age = 24 if agehh == 10

replace age = 27 if agehh == 11
replace age = 32 if agehh == 12
replace age = 37 if agehh == 13
replace age = 42 if agehh == 14
replace age = 47 if agehh == 15
replace age = 52 if agehh == 16

replace age = 55 if agehh == 17
replace age = 56 if agehh == 18
replace age = 57 if agehh == 19
replace age = 58 if agehh == 20
replace age = 59 if agehh == 21
replace age = 60 if agehh == 22
replace age = 61 if agehh == 23
replace age = 62 if agehh == 24
replace age = 63 if agehh == 25
replace age = 64 if agehh == 26

replace age = 67 if agehh == 27
replace age = 72 if agehh == 28
replace age = 77 if agehh == 29
replace age = 80 if agehh == 30


rename WEALTHH nwealth 

rename ISUPERCH superinc 
rename LFSRH lfstatus 



g children = NUMU15BC
g persons = PERSHBC
g adults = persons - children

g couplenokids = (DCOMP == 1)
g couplekids = (DCOMP > 1 & DCOMP <17)
g singleparent = (DCOMP > 16 & DCOMP <25)
g loneperson = (DCOMP == 32)


g tenure = TENURECF 
g owner = (tenure == 1 | tenure == 2)
g mortgagor = (tenure == 2)
g renter = (tenure == 3)

g fhb = (FSTHHCF == 1)


g hvalue = HVALUECH
g otherprop = VRPRCH
g resassets = hvalue+otherprop

g gsuper = VSUPGCH
g psuper = VSUPNCH
g super = gsuper+psuper

g trusts = VTRTCH


g dep = VFINCH
g off = 0
g bank = dep+off

g bonds = VDEBCH
g shares = VSHARCH

g hdebt_purch = TOWE1CH
g hdebt_alts = TOWE2CH
g hdebt_other = TOWE3ACH
g hdebt_unsec = TOWE4CH

g hdebt = hdebt_purch+hdebt_alts
g resdebt = hdebt_purch+hdebt_alts+hdebt_other+hdebt_unsec

g ccdebt = LIACCCH
g pdebt = LIAVECH+LIAINVCH+LIAOTCH


g liq_debt = ccdebt 
g liq_debt1 = ccdebt + pdebt 

g car = VVEHICH 

g inc_source=PSRCPH


keep abshid year liaopch liarpch state  femshh maleshh  noearnbc investment_inc bus_inc all_inc gov_inc super_inc employee_inc debts assets ccdebt pdebt car bank shares super hvalue otherprop renter fhb trust hdebt bonds dinc age nwealth resassets resdebt adults children owner mortgagor superinc lfstatus couple* single lone HESHHWT inc_source


append using "$path\data\data\2004_2018.dta"

save "$path\data\2004_2018withHES.dta" 




























